'use client';
import { useLocale, useTranslations } from 'next-intl';
import { Link } from '@/i18n/routing';


export default function Home() {
  const locale = useLocale() as 'ar' | 'en';
  const t = useTranslations('Careers');


  return (
    <>
      <div className='min-h-93.25 w-full flex flex-col justify-start items-center gap-0'>
        <div className="bg-white flex flex-col gap-2 w-full container">
          <div className="flex p-4 md:p-0 h-100 md:h-148.25 justify-center align-middle flex-col gap-4 md:gap-2 w-full bg-[url(/assets/images/00006.png)]  bg-no-repeat bg-bottom bg-contain">
            <div className="w-fit text-main-blue font-main text-4xl font-bold">نبني المستقبل...</div>
            <div className="w-fit text-main-orange font-main text-4xl font-bold md:pt-5 md:ps-25">بثقة وجودة عالية</div>
            <div className="w-90 md:pt-10 text-blue-600 font-main text-lg font-light line-clamp-2">نقدم حلولاً هندسية متكاملة تجمع بين الجودة، السرعة، والدقة في التنفيذ في مختلف القطاعات.</div>
            <div className="flex  mt-10 cursor-pointer w-fit p-2 items-center flex-row gap-2 bg-main-orange rounded-xl">
              <div className="text-white font-semibold font-main text-base">تعرف على مشاريعنا</div>
              <svg className="size-9" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                <rect width="36" height="36" rx="10" fill="white" />
                <path d="M24 16.9998H14L17.29 13.7098C17.3837 13.6169 17.4581 13.5063 17.5089 13.3844C17.5597 13.2625 17.5858 13.1318 17.5858 12.9998C17.5858 12.8678 17.5597 12.7371 17.5089 12.6152C17.4581 12.4934 17.3837 12.3828 17.29 12.2898C17.1026 12.1036 16.8492 11.999 16.585 11.999C16.3208 11.999 16.0674 12.1036 15.88 12.2898L11.59 16.5898C11.2144 16.9632 11.0022 17.4702 11 17.9998C11.0049 18.5259 11.2168 19.0289 11.59 19.3998L15.88 23.6998C15.9732 23.7924 16.0838 23.8657 16.2054 23.9156C16.3269 23.9654 16.4571 23.9908 16.5885 23.9904C16.7199 23.9899 16.8499 23.9636 16.9712 23.9129C17.0924 23.8621 17.2024 23.7881 17.295 23.6948C17.3876 23.6016 17.4609 23.491 17.5107 23.3694C17.5606 23.2479 17.586 23.1177 17.5856 22.9863C17.5851 22.8549 17.5588 22.7249 17.508 22.6037C17.4573 22.4824 17.3832 22.3724 17.29 22.2798L14 18.9998H24C24.2652 18.9998 24.5196 18.8945 24.7071 18.7069C24.8946 18.5194 25 18.265 25 17.9998C25 17.7346 24.8946 17.4802 24.7071 17.2927C24.5196 17.1052 24.2652 16.9998 24 16.9998Z" fill="#FF6400" />
              </svg>
            </div>
          </div>
        </div>
        <div className='flex w-full -mt-19 relative h-18.5 bg-no-repeat bg-cover bg-top bg-[url(/assets/images/topPattern.svg)]' />
        <div className="bg-main-blue h-screen flex flex-col gap-2 w-full bg-[url(/assets/images/00007.png)]  bg-no-repeat bg-bottom bg-contain">
          <div className="container flex flex-col justify-start gap-10 p-4">
            <div className='text-[40px] text-white font-main'>{locale == "ar" ? "مشاريع نفخر بها" : "Proudly Built"}</div>
            <Link
              href="/pages/ongoing-projects"
              locale={locale}
              className="flex w-full rounded-2xl bg-white/20 p-4 flex-col md:flex-row gap-10"
            >
              <div className='flex flex-10 w-full font-light text-white text-[18px] font-almarai'>
                {
                  locale == "ar" ? "نفذت شركة السلام للمقاولات مئات المشاريع المتنوعة في مختلف القطاعات، تشمل المستشفيات، الجامعات، المجمعات التجارية، والمشاريع السكنية الكبرى في العاصمة الإدارية ومختلف أنحاء مصر."
                    : "Al-Salam Construction has executed hundreds of diverse projects across various sectors, including hospitals, universities, commercial complexes, and major residential projects in the New Administrative Capital and throughout Egypt."
                }
              </div>
              <div className='flex flex-2 w-full text-white text-[18px] font-almarai flex-col gap-2 cursor-pointer'>
                <div className='font-bold'>{locale == "ar" ? "500+ مشروع" : "500+ Projects"}</div>
                <div>{locale == "ar" ? "شاهــــــد المزيد ←" : "See More →"}</div>
              </div>
            </Link>
            <div className='flex flex-col md:flex-row gap-10 w-full'>
              
              <div className='flex flex-col gap-4 bg-white/20 rounded-2xl p-4'>
                <div className='relative flex flex-col w-full rounded-2xl overflow-hidden h-65.75'>
                  <img src='/assets/images/00008.png' alt="" title="" className='w-full h-full' />
                  <div className='flex flex-row gap-3 flex-wrap absolute bottom-2 start-2'>
                    <div className='bg-white text-main-orange font-light text-base rounded-2xl p-2'>2010</div>
                    <div className='bg-white text-main-orange font-light text-base rounded-2xl p-2'>{locale == "ar" ? "ديني / ثقافي" : "Religious / Cultural"}</div>
                  </div>
                </div>
                <div className='text-white font-bold text-2xl font-main'>{locale == "ar" ? "مسجد مصر – متحف دار القرآن" : "Misr Mosque – Dar Al-Qur’an Museum"}</div>
                <div className='text-white font-light text-lg font-almarai'>{locale == "ar" ? "إنشاء مركز لتحفيظ القرآن الكريم ومركز ثقافي إسلامي يضم قاعتين لكبار الزوار، وغرفة للمقتنيات النبوية، ولوبي، ومنطقة السلالم المؤدية لبيت القرآن" : "Establishment of a Holy Qur’an Memorization Center and an Islamic Cultural Center, featuring two VIP halls, a Prophet’s relics room, a main lobby, and the staircase area leading to the House of the Qur’an."}</div>
                <div className='flex flex-row justify-between gap-2 '>
                  <div className='flex w-fit'>
                    <svg className='size-10' viewBox="0 0 45 45" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <rect width="45" height="45" rx="22.5" fill="#FF6400" />
                      <g clipPath="url(#clip0_14144_2501)">
                        <path d="M22.0001 13.0352C19.7951 13.0376 17.681 13.9146 16.1217 15.4737C14.5624 17.0328 13.6853 19.1468 13.6826 21.3518C13.6826 23.4935 15.341 26.8452 18.6118 31.3135C19.0012 31.8469 19.511 32.2809 20.0998 32.5801C20.6886 32.8793 21.3397 33.0352 22.0001 33.0352C22.6606 33.0352 23.3117 32.8793 23.9004 32.5801C24.4892 32.2809 24.9991 31.8469 25.3885 31.3135C28.6593 26.8452 30.3176 23.4935 30.3176 21.3518C30.315 19.1468 29.4378 17.0328 27.8785 15.4737C26.3192 13.9146 24.2052 13.0376 22.0001 13.0352ZM22.0001 24.6668C21.3408 24.6668 20.6964 24.4713 20.1482 24.1051C19.6001 23.7388 19.1728 23.2182 18.9205 22.6091C18.6682 22 18.6022 21.3298 18.7308 20.6832C18.8595 20.0366 19.1769 19.4426 19.6431 18.9765C20.1093 18.5103 20.7032 18.1928 21.3498 18.0642C21.9964 17.9356 22.6666 18.0016 23.2757 18.2539C23.8848 18.5062 24.4054 18.9334 24.7717 19.4816C25.138 20.0298 25.3335 20.6742 25.3335 21.3335C25.3335 22.2175 24.9823 23.0654 24.3571 23.6905C23.732 24.3156 22.8842 24.6668 22.0001 24.6668Z" fill="white" />
                      </g>
                      <defs>
                        <clipPath id="clip0_14144_2501">
                          <rect width="20" height="20" fill="white" transform="translate(12 13)" />
                        </clipPath>
                      </defs>
                    </svg>

                  </div>
                  <div className='flex w-full flex-col gap-1'>
                    <div className='text-white font-almarai text-lg font-bold'>{locale == "ar" ? "الموقع" : "Location"}</div>
                    <div className='text-white font-almarai text-base'>{locale == "ar" ? "العاصمة الإدارية الجديدة - مصر" : "New Administrative Capital – Egypt"}</div>
                  </div>
                  <div className="flex cursor-pointer w-26 p-2 items-center flex-row gap-2 bg-main-orange rounded-xl">
                    <div className="text-white font-light text-base">{locale == "ar" ? "المزيد ←" : "More →"}</div>
                  </div>
                </div>
              </div>
              <div className='flex flex-col gap-4 bg-white/20 rounded-2xl p-4'>
                <div className='relative flex flex-col w-full rounded-2xl overflow-hidden h-65.75'>
                  <img src='/assets/images/00009.png' alt="" title="" className='w-full h-full' />
                  <div className='flex flex-row gap-3 flex-wrap absolute bottom-2 start-2'>
                    <div className='bg-white text-main-orange font-light text-base rounded-2xl p-2'>2010</div>
                    <div className='bg-white text-main-orange font-light text-base rounded-2xl p-2'>{locale == "ar" ? "ديني / ثقافي" : "Religious / Cultural"}</div>
                  </div>
                </div>
                <div className='text-white font-bold text-2xl font-main'>{locale == "ar" ? "مسجد مصر – متحف دار القرآن" : "Misr Mosque – Dar Al-Qur’an Museum"}</div>
                <div className='text-white font-light text-lg font-almarai'>{locale == "ar" ? "إنشاء مركز لتحفيظ القرآن الكريم ومركز ثقافي إسلامي يضم قاعتين لكبار الزوار، وغرفة للمقتنيات النبوية، ولوبي، ومنطقة السلالم المؤدية لبيت القرآن" : "Establishment of a Holy Qur’an Memorization Center and an Islamic Cultural Center, featuring two VIP halls, a Prophet’s relics room, a main lobby, and the staircase area leading to the House of the Qur’an."}</div>
                <div className='flex flex-row justify-between gap-2 '>
                  <div className='flex w-fit'>
                    <svg className='size-10' viewBox="0 0 45 45" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <rect width="45" height="45" rx="22.5" fill="#FF6400" />
                      <g clipPath="url(#clip0_14144_2501)">
                        <path d="M22.0001 13.0352C19.7951 13.0376 17.681 13.9146 16.1217 15.4737C14.5624 17.0328 13.6853 19.1468 13.6826 21.3518C13.6826 23.4935 15.341 26.8452 18.6118 31.3135C19.0012 31.8469 19.511 32.2809 20.0998 32.5801C20.6886 32.8793 21.3397 33.0352 22.0001 33.0352C22.6606 33.0352 23.3117 32.8793 23.9004 32.5801C24.4892 32.2809 24.9991 31.8469 25.3885 31.3135C28.6593 26.8452 30.3176 23.4935 30.3176 21.3518C30.315 19.1468 29.4378 17.0328 27.8785 15.4737C26.3192 13.9146 24.2052 13.0376 22.0001 13.0352ZM22.0001 24.6668C21.3408 24.6668 20.6964 24.4713 20.1482 24.1051C19.6001 23.7388 19.1728 23.2182 18.9205 22.6091C18.6682 22 18.6022 21.3298 18.7308 20.6832C18.8595 20.0366 19.1769 19.4426 19.6431 18.9765C20.1093 18.5103 20.7032 18.1928 21.3498 18.0642C21.9964 17.9356 22.6666 18.0016 23.2757 18.2539C23.8848 18.5062 24.4054 18.9334 24.7717 19.4816C25.138 20.0298 25.3335 20.6742 25.3335 21.3335C25.3335 22.2175 24.9823 23.0654 24.3571 23.6905C23.732 24.3156 22.8842 24.6668 22.0001 24.6668Z" fill="white" />
                      </g>
                      <defs>
                        <clipPath id="clip0_14144_2501">
                          <rect width="20" height="20" fill="white" transform="translate(12 13)" />
                        </clipPath>
                      </defs>
                    </svg>

                  </div>
                  <div className='flex w-full flex-col gap-1'>
                    <div className='text-white font-almarai text-lg font-bold'>{locale == "ar" ? "الموقع" : "Location"}</div>
                    <div className='text-white font-almarai text-base'>{locale == "ar" ? "العاصمة الإدارية الجديدة - مصر" : "New Administrative Capital – Egypt"}</div>
                  </div>
                  <div className="flex cursor-pointer w-26 p-2 items-center flex-row gap-2 bg-main-orange rounded-xl">
                    <div className="text-white font-light text-base">{locale == "ar" ? "المزيد ←" : "More →"}</div>
                  </div>
                </div>
              </div>



            </div>
          </div>
        </div>
      </div>
    </>
  );
}